/**
*    CornerToCorner.cpp
*    
*    Extention of Routine to light up the cube starting at a corner.
*    
*    Program written by Lopuz3
*    Spring 2013 
**/

#include "Arduino.h"
#include "CornerToCorner.h"

CornerToCorner::CornerToCorner()
{
	timeSinceLastStep = 0;
	step = 0;
	growing = true;
	xHigh = random(2);
	yHigh = random(2);
	zHigh = random(2);
}

void CornerToCorner::update(unsigned long dt)
{	
	timeSinceLastStep += dt;
	if (timeSinceLastStep > STEP_TIME)
	{
		if(growing)
		{
			for(byte x = 0 ; x < CUBE_SIZE ; x++)
			{
				for(byte y = 0 ; y < CUBE_SIZE ; y++)
				{
					for(byte z = 0 ; z < CUBE_SIZE ; z++)
					{
						int xDist = x;
						if(xHigh)
						{
							xDist = CUBE_SIZE -x -1;
						}
						int yDist = y;
						if(yHigh)
						{
							yDist = CUBE_SIZE -y -1;
						}
						int zDist = z;
						if(zHigh)
						{
							zDist = CUBE_SIZE -z -1;
						}
						cubeModel[x][y][z] = (xDist + yDist + zDist <= step);
					}
				}
			}
			step++;
			if(step > (CUBE_SIZE-1)*3)
			{
				step = 0;
				growing = false;
			}
		}
		else
		{
			for(byte x = 0 ; x < CUBE_SIZE ; x++)
			{
				for(byte y = 0 ; y < CUBE_SIZE ; y++)
				{
					for(byte z = 0 ; z < CUBE_SIZE ; z++)
					{
						int xDist = x;
						if(xHigh)
						{
							xDist = CUBE_SIZE -x -1;
						}
						int yDist = y;
						if(yHigh)
						{
							yDist = CUBE_SIZE -y -1;
						}
						int zDist = z;
						if(zHigh)
						{
							zDist = CUBE_SIZE -z -1;
						}
						cubeModel[x][y][z] = !(xDist + yDist + zDist <= step);
					}
				}
			}
			step++;
			if(step > (CUBE_SIZE-1)*3)
			{
				step = 0;
				growing = true;
				xHigh = random(2);
				yHigh = random(2);
				zHigh = random(2);
			}
		}
		timeSinceLastStep -= STEP_TIME;
	}
}